function [Jacobian, inv_relative_POS, inv_POS, true_quad_pos, grad_eta_inv] = comp_Jac;

global_vars;

ID_n_quad_2d = sparse(eye(2*n_quad_2d));

for elem_no=1:n_elem
    inv_POS{elem_no}= sparse(2*n_quad_2d,2*n_quad_2d);
    Position1 = u_node_pos(elem_u_node_pos(elem_no,1),:); % The location of vertex 1
    Position2 = u_node_pos(elem_u_node_pos(elem_no,2),:); % The location of vertex 2
    Position3 = u_node_pos(elem_u_node_pos(elem_no,3),:); % The location of vertex 3
    POS = [Position3(1) - Position1(1), Position2(1)-Position1(1); Position3(2) - Position1(2), Position2(2)-Position1(2)];
    Jacobian(elem_no,1) = abs(POS(1,1)*POS(2,2) - POS(1,2)*POS(2,1)); % the absolute value of the determinant of POS
    inv_relative_POS{elem_no} = inv(POS);
    for ell=1:n_quad_2d
        inv_POS{elem_no}(2*ell-1:2*ell,2*ell-1:2*ell) = inv_relative_POS{elem_no};
    end
    true_quad_pos{elem_no} = quad_2d_point*POS' + [Position1(1)*ones(n_quad_2d,1),Position1(2)*ones(n_quad_2d,1)];
    grad_eta_inv{elem_no} = ID_n_quad_2d;
end